﻿--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueUsers

CREATE PROCEDURE [App].[NVCC_usp_ProductionAccessLogUniqueUsers]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueUsers
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert from vNVCC_ProducionAccessLog, SStaff, and NVCC_Users
--                      : to NVCC_ProductionLog and LCustomer
--
--Purpose               : Get unique users from the access log
--==================================================================================
--Uses: App.NVCC_ProductionLog
--Uses: CDWWork.LCustomer.LCustomer
BEGIN
	SELECT
		U.UserID,
		lc.LastName + ', ' + lc.FirstName AS StaffName,
		U.Sta3n
	FROM (
		SELECT DISTINCT
			pl.UserID,
			pl.Sta3n
		FROM
			App.NVCC_ProductionLog pl
	) AS U
		LEFT JOIN CDWWork.LCustomer.LCustomer lc
			ON U.UserID = lc.ADDomain + '\' + lc.ADLogin
	ORDER BY StaffName
END

